/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.UsuariosController;
import com.seguros.modelo.Roles;
import com.seguros.modelo.Usuarios;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.UsuariosView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@PageTitle(value="Datos Maestros -> Usuarios")
@Route(value="usuarios", layout=MainLayout.class)
@RolesAllowed(value={"USUARIOS", "ADMIN"})
public class UsuariosView
extends Div {
    private final UsuariosController controller = new UsuariosController();
    private final Grid<Usuarios> grid = new Grid(Usuarios.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button reiniciarpasswordButton = new Button("Reiniciar Password");
    private final Button gestionarRolesButton = new Button("Gestionar Accesos");

    public UsuariosView() {
        this.configureGrid();
        H3 title = new H3("USUARIOS");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione las usuarios por medio las cuales se pueden expedir p\u00f3lizas");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.editButton.setIcon((Component)new Icon(VaadinIcon.PENCIL));
        this.reiniciarpasswordButton.setIcon((Component)new Icon(VaadinIcon.PASSWORD));
        this.gestionarRolesButton.setIcon((Component)new Icon(VaadinIcon.USER_CARD));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Usuarios()));
        this.editButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Usuarios selected = (Usuarios)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showEditDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a editar");
            }
        });
        this.reiniciarpasswordButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Usuarios selected = (Usuarios)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showReiniciarPasswordDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a modificar");
            }
        });
        this.gestionarRolesButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Usuarios selected = (Usuarios)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showGestionarAccesosDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a modificar");
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.editButton, this.reiniciarpasswordButton, this.gestionarRolesButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "numerodocumento", "nombre", "usuario", "email", "estado"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("numerodocumento").setHeader("N\u00daMERO DE DOCUMENTO");
        this.grid.getColumnByKey("nombre").setHeader("NOMBRE");
        this.grid.getColumnByKey("usuario").setHeader("USUARIO");
        this.grid.getColumnByKey("email").setHeader("EMAIL");
        this.grid.getColumnByKey("estado").setHeader("ESTADO");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
        this.updateList("");
    }

    private void updateList(String value) {
        List usuarios = this.getFilteredUsuarios(value);
        this.grid.setItems((Collection)usuarios);
    }

    private List<Usuarios> getFilteredUsuarios(String filterValue) {
        List usuarios = this.controller.getAllUsuarios();
        if (filterValue == null || filterValue.isEmpty()) {
            return usuarios;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return usuarios.stream().filter(t -> t.getNombre() != null && t.getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getUsuario() != null && t.getUsuario().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEmail() != null && t.getEmail().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEstado() != null && t.getEstado().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getNumerodocumento() != null && t.getNumerodocumento().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getNombre() != null && t.getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Usuarios usuarios) {
        EditDialog dialog = new EditDialog(this, usuarios);
        dialog.open();
    }

    private void showGestionarAccesosDialog(Usuarios selected) {
        Dialog dialog = new Dialog();
        dialog.setWidth("500px");
        dialog.setHeight("600px");
        H2 titulo = new H2("Gesti\u00f3n de roles");
        Span usuariotxt = new Span("Permisos para el usuario: " + selected.getNombre());
        usuariotxt.getStyle().set("color", "blue");
        Grid gridroles = new Grid(Roles.class);
        gridroles.setColumns(new String[]{"nombre"});
        gridroles.getColumnByKey("nombre").setHeader("ROL");
        HashMap rolesCheckboxMap = new HashMap();
        List items = InicioApp.getLroles();
        gridroles.setItems((Collection)items);
        gridroles.addComponentColumn((ValueProvider & Serializable)item -> {
            Checkbox checkbox = new Checkbox();
            boolean isActive = selected.getRoles().stream().anyMatch(role -> role.getNombre().equals(item.getNombre()));
            checkbox.setValue((Object)isActive);
            rolesCheckboxMap.put(item, checkbox);
            return checkbox;
        }).setHeader("ACTIVO");
        Button acceptButton = new Button("Aceptar", (ComponentEventListener & Serializable)event -> {
            List rolesSeleccionados = rolesCheckboxMap.entrySet().stream().filter(entry -> (Boolean)((Checkbox)entry.getValue()).getValue()).map(Map.Entry::getKey).collect(Collectors.toList());
            selected.setRoles(rolesSeleccionados);
            this.controller.createOrUpdateUsuarios(selected);
            dialog.close();
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        HorizontalLayout buttonLayout = new HorizontalLayout(new Component[]{acceptButton, cancelButton});
        VerticalLayout dialogLayout = new VerticalLayout(new Component[]{titulo, usuariotxt, gridroles, buttonLayout});
        dialog.add(new Component[]{dialogLayout});
        dialog.setCloseOnOutsideClick(false);
        dialog.setCloseOnEsc(false);
        dialog.open();
    }

    private void showReiniciarPasswordDialog(Usuarios usuarios) {
        Dialog dialog = new Dialog();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.add("\u00bfEst\u00e1s seguro de que quieres reinicar el password de este usuario?");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button deleteButton = new Button("Aceptar", (ComponentEventListener & Serializable)event -> {
            this.controller.reinicarpaswordUsuarios(usuarios.getId().intValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{deleteButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        verticalLayout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{verticalLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

