/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.security.AuthenticatedUser;
import com.seguros.vistas.CarteraView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.PolizasView;
import com.seguros.vistas.PresupuestoView;
import com.seguros.vistas.ProduccionViewCard;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.OrderedList;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;

@PageTitle(value="Producci\u00f3n")
@Route(value="produccion", layout=MainLayout.class)
@RolesAllowed(value={"PRODUCCION", "ADMIN"})
public class ProduccionView
extends Main
implements HasComponents,
HasStyle {
    private OrderedList imageContainer = new OrderedList();

    public ProduccionView(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        this.imageContainer.addClassNames(new String[]{"gap-m", "grid", "list-none", "m-0", "p-0"});
        boolean esvacio = false;
        if (accessChecker.hasAccess(PolizasView.class)) {
            ProduccionViewCard menuPolizas = new ProduccionViewCard("Polizas", "/images/polizas.png", "P\u00f3lizas", "Informaci\u00f3n de p\u00f3lizas", "Administraci\u00f3n de informaci\u00f3n de polizas");
            this.imageContainer.add(new Component[]{menuPolizas});
            menuPolizas.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(PolizasView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(CarteraView.class)) {
            ProduccionViewCard menuCartera = new ProduccionViewCard("Cartera", "/images/cartera.png", "Cartera", "Informaci\u00f3n de cartera de sus clientes", "Haga seguimiento al comportamiento de los pagos de sus clientes con p\u00f3lizas financiadas");
            this.imageContainer.add(new Component[]{menuCartera});
            menuCartera.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(CarteraView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(PresupuestoView.class)) {
            ProduccionViewCard menuPresupuesto = new ProduccionViewCard("Presupuesto", "/images/presupuesto.png", "Presupuesto", "Informaci\u00f3n de presupuestos", "Administre los presupuestos de producci\u00f3n");
            this.imageContainer.add(new Component[]{menuPresupuesto});
            menuPresupuesto.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(PresupuestoView.class)));
            esvacio = true;
        }
        this.constructUI(esvacio);
    }

    private void constructUI(boolean elementos) {
        this.addClassNames(new String[]{"produccion-view"});
        this.addClassNames(new String[]{"max-w-screen-lg", "mx-auto", "pb-l", "px-l"});
        HorizontalLayout container = new HorizontalLayout();
        container.addClassNames(new String[]{"items-center", "justify-between"});
        VerticalLayout headerContainer = new VerticalLayout();
        if (elementos) {
            header = new H2("Producci\u00f3n");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("seleccione la opci\u00f3n deseada");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        } else {
            header = new H2("UPPS...HA OCURRIDO UN ERROR");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("NO TIENE ACCESO A ESTE MODULO");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        }
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        container.add(new Component[]{headerContainer});
        this.add(new Component[]{container, this.imageContainer, footerLayout});
    }
}

