/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.ClientesController;
import com.seguros.controlador.PolizasController;
import com.seguros.controlador.ProduccionController;
import com.seguros.modelo.Polizas;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.PolizasView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@PageTitle(value="Producci\u00f3n -> P\u00f3lizas")
@Route(value="polizas", layout=MainLayout.class)
@RolesAllowed(value={"POLIZAS", "ADMIN"})
public class PolizasView
extends Div {
    private final PolizasController controller = new PolizasController();
    private final ClientesController controllerCliente = new ClientesController();
    private final ProduccionController controllerProduccion = new ProduccionController();
    private final NumberFormat formatoMoneda = NumberFormat.getCurrencyInstance(new Locale("es", "CO"));
    private final Grid<Polizas> grid = new Grid(Polizas.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button deleteButton = new Button("Eliminar");
    private final Button filesButton = new Button("Gestionar Archivos");

    public PolizasView() {
        this.configureGrid();
        H3 title = new H3("P\u00d3LIZAS");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione las p\u00f3liza");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.editButton.setIcon((Component)new Icon(VaadinIcon.PENCIL));
        this.deleteButton.setIcon((Component)new Icon(VaadinIcon.TRASH));
        this.filesButton.setIcon((Component)new Icon(VaadinIcon.FILE_ADD));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Polizas()));
        this.editButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Polizas selected = (Polizas)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showEditDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a editar");
            }
        });
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Polizas selected = (Polizas)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showDeleteDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a eliminar");
            }
        });
        this.filesButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Polizas selected = (Polizas)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showFilesManegerDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione una p\u00f3liza");
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.editButton, this.deleteButton, this.filesButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "numeropoliza", "fechainiciovigencia", "placa", "numerocredito", "plazocredito"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("id").setHeader("ID");
        this.grid.getColumnByKey("numeropoliza").setHeader("NUMEROP\u00d3LIZA");
        this.grid.getColumnByKey("fechainiciovigencia").setHeader("FECHAINICIOVIGENCIA");
        this.grid.getColumnByKey("placa").setHeader("PLACA");
        this.grid.getColumnByKey("numerocredito").setHeader("NUMEROCREDITO");
        this.grid.getColumnByKey("plazocredito").setHeader("PLAZOCREDITO");
        this.updateList("");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getCliente() != null ? poliza.getCliente().getNumerodocumento() + " - " + poliza.getCliente().getNombrecompleto() : "").setHeader("CLIENTE").setKey("clientenumerodocumento");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProducto() != null ? poliza.getProducto().getNombre() + " - " + poliza.getProducto().getRamo().getNombre() : "").setHeader("PRODUCTO - RAMO").setKey("productonombre");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getAseguradora() != null ? poliza.getAseguradora().getNombre() : "").setHeader("ASEGURADORA").setKey("aseguradoranombre");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getAsesor() != null ? poliza.getAsesor().getNombre() : "").setHeader("ASESOR").setKey("asesoranombre");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getAgencia() != null ? poliza.getAgencia().getNombre() : "").setHeader("AGENCIA").setKey("agencianombre");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getEstadopoliza() != null ? poliza.getEstadopoliza().getDescripcion() : "").setHeader("ESTADO P\u00d3LIZA").setKey("estadopolizadescripcion");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getTipooperacion() != null ? poliza.getTipooperacion().getDescripcion() : "").setHeader("TIPO OPERACI\u00d3N").setKey("tipooperacioncodigo");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? this.formatoMoneda.format(poliza.getProduccion().getPrimaneta()) : "").setHeader("PRIMA NETA").setKey("primaneta");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? this.formatoMoneda.format(poliza.getProduccion().getComisiondespuesimp()) : "").setHeader("COMISI\u00d3N DESPUES DE IMP.").setKey("comisiondespuesdeimp");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? this.formatoMoneda.format(poliza.getProduccion().getComisionasesor()) : "").setHeader("COMISI\u00d3N ASESOR").setKey("comisionasesor");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? this.formatoMoneda.format(poliza.getProduccion().getComisiontotal()) : "").setHeader("COMISI\u00d3N TOTAL").setKey("comisiontotal");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? poliza.getProduccion().getFecharecaudo() : "").setHeader("FECHA RECAUDO REAL").setKey("fecharecaudo");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? poliza.getProduccion().getFechaestimadarecaudo() : "").setHeader("FECHA ESTIMADA RECAUDO").setKey("fechaestimadorecaudo");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? poliza.getProduccion().getEstadocomision().getDescripcion() : "").setHeader("ESTADO DE LA COMISI\u00d3N").setKey("estadocomision");
        this.grid.addColumn((ValueProvider & Serializable)poliza -> poliza.getProduccion() != null ? this.formatoMoneda.format(poliza.getProduccion().getValorComisionReversada()) : "").setHeader("COMISI\u00d3N REVERSADA").setKey("comisionreversada");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
    }

    private void updateList(String value) {
        List polizas = this.getFilteredPolizas(value);
        this.grid.setItems((Collection)polizas);
    }

    private List<Polizas> getFilteredPolizas(String filterValue) {
        List polizas = this.controller.getAllPolizas();
        if (filterValue == null || filterValue.isEmpty()) {
            return polizas;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return polizas.stream().filter(t -> t.getNumeropoliza() != null && t.getNumeropoliza().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getPlaca() != null && t.getPlaca().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getCliente() != null && t.getCliente().getNumerodocumento().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getCliente() != null && t.getCliente().getNombrecompleto().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getProducto() != null && t.getProducto().getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getAgencia() != null && t.getAgencia().getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getAsesor() != null && t.getAsesor().getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getAseguradora() != null && t.getAseguradora().getNombre().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEstadopoliza() != null && t.getEstadopoliza().getDescripcion().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getTipooperacion() != null && t.getTipooperacion().getDescripcion().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getProduccion().getEstadocomision() != null && t.getProduccion().getEstadocomision().getDescripcion().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Polizas polizas) {
        EditDialog dialog = new EditDialog(this, polizas);
        dialog.open();
    }

    private void showFilesManegerDialog(Polizas poliza) {
        FileManagerDialog dialog = new FileManagerDialog(this, poliza);
        dialog.open();
    }

    private void showDeleteDialog(Polizas polizas) {
        Dialog dialog = new Dialog();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.add("\u00bfEst\u00e1s seguro de que quieres eliminar este registro?");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button deleteButton = new Button("Eliminar", (ComponentEventListener & Serializable)event -> {
            this.controllerProduccion.deleteProduccion(polizas.getProduccion().getId().intValue());
            this.controller.deletePolizas(polizas.getId().intValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{deleteButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        verticalLayout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{verticalLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

