/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.security.AuthenticatedUser;
import com.seguros.vistas.AsesoresView;
import com.seguros.vistas.ClientesView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.seguros.vistas.PersonasViewCard;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.OrderedList;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;

@PageTitle(value="Personas")
@Route(value="personas", layout=MainLayout.class)
@RolesAllowed(value={"PERSONAS", "ADMIN"})
public class PersonasView
extends Main
implements HasComponents,
HasStyle {
    private OrderedList imageContainer = new OrderedList();

    public PersonasView(AuthenticatedUser authenticatedUser, AccessAnnotationChecker accessChecker) {
        this.imageContainer.addClassNames(new String[]{"gap-m", "grid", "list-none", "m-0", "p-0"});
        boolean esvacio = false;
        if (accessChecker.hasAccess(AsesoresView.class)) {
            PersonasViewCard asesores = new PersonasViewCard("Asesores", "/images/Asesores.png", "Asesores", "Informaci\u00f3n de asesores", "Gestione la informaci\u00f3n de asesores");
            this.imageContainer.add(new Component[]{asesores});
            asesores.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(AsesoresView.class)));
            esvacio = true;
        }
        if (accessChecker.hasAccess(ClientesView.class)) {
            PersonasViewCard clientes = new PersonasViewCard("Clientes", "/images/clientes.png", "Clientes", "Informaci\u00f3n de clientes", "Gestione la informaci\u00f3n de clientes");
            this.imageContainer.add(new Component[]{clientes});
            clientes.addClickListener((ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.navigate(ClientesView.class)));
            esvacio = true;
        }
        this.constructUI(esvacio);
    }

    private void constructUI(boolean elementos) {
        this.addClassNames(new String[]{"personas-view"});
        this.addClassNames(new String[]{"max-w-screen-lg", "mx-auto", "pb-l", "px-l"});
        HorizontalLayout container = new HorizontalLayout();
        container.addClassNames(new String[]{"items-center", "justify-between"});
        VerticalLayout headerContainer = new VerticalLayout();
        if (elementos) {
            header = new H2("Personas");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("Seleccione la opcion deseada");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        } else {
            header = new H2("UPPS...HA OCURRIDO UN ERROR");
            header.addClassNames(new String[]{"mb-0", "mt-xl", "text-3xl"});
            description = new Paragraph("NO TIENE ACCESO A ESTE MODULO");
            description.addClassNames(new String[]{"mb-xl", "mt-0", "text-secondary"});
            headerContainer.add(new Component[]{header, description});
        }
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        container.add(new Component[]{headerContainer});
        this.add(new Component[]{container, this.imageContainer, footerLayout});
    }
}

