/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.Serializable;

public class FooterView
extends VerticalLayout {
    public FooterView() {
        Span developedByText = new Span("Desarrollado por: B-Smart Consulting");
        developedByText.getStyle().setColor("blue");
        developedByText.getStyle().setFontWeight("bold");
        StreamResource imageResource = new StreamResource("Logo", (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream("/images/Logo B-Smart.png"));
        Image logoImage = new Image();
        logoImage.setSrc((AbstractStreamResource)imageResource);
        logoImage.setAlt("Logo");
        logoImage.setWidth("30px");
        logoImage.setHeight("30px");
        HorizontalLayout logoAndTextLayout = new HorizontalLayout(new Component[]{logoImage, developedByText});
        logoAndTextLayout.setWidthFull();
        logoAndTextLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        Button whatsappButton = this.createWhatsAppButton("/images/whatsapp.png", "WhatsApp", "whatsapp", "+573003363897");
        Button facebookButton = this.createSocialMediaButton("/images/facebook.png", "Facebook", "facebook", "https://www.facebook.com/BSmartConsultingSAS");
        Button linkedinButton = this.createSocialMediaButton("/images/linkedin.png", "LinkedIn", "linkedin", "https://www.linkedin.com/in/fernando-jaime-sarmiento-palacio-10076289");
        Button instagramButton = this.createSocialMediaButton("/images/instagram.png", "Instagram", "instagram", "https://www.instagram.com/p/CwtfWqoOKEs");
        Anchor webpageLink = new Anchor("https://www.b-smart.com.co", "www.b-smart.com.co");
        webpageLink.setTarget("_blank");
        webpageLink.getStyle().set("white-space", "nowrap");
        webpageLink.setWidthFull();
        HorizontalLayout buttonsAndWebpageLayout = new HorizontalLayout(new Component[]{webpageLink, whatsappButton, linkedinButton, instagramButton, facebookButton});
        buttonsAndWebpageLayout.setSpacing(true);
        buttonsAndWebpageLayout.setWidthFull();
        buttonsAndWebpageLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        FlexLayout layout = new FlexLayout();
        layout.setWidthFull();
        layout.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        layout.add(new Component[]{logoAndTextLayout});
        FlexLayout buttonsAndWebpageContainer = new FlexLayout(new Component[]{buttonsAndWebpageLayout});
        buttonsAndWebpageContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        layout.add(new Component[]{buttonsAndWebpageContainer});
        this.add(new Component[]{layout});
    }

    private Button createWhatsAppButton(String iconPath, String tooltip, String nombre, String phoneNumber) {
        Button button = new Button();
        StreamResource iconResource = new StreamResource(nombre, (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream(iconPath));
        Image iconImage = new Image((AbstractStreamResource)iconResource, nombre);
        iconImage.setWidth("24px");
        iconImage.setHeight("24px");
        button.setIcon((Component)iconImage);
        button.getElement().setAttribute("theme", "tertiary");
        button.getElement().setAttribute("title", tooltip);
        String waLink = "https://wa.me/" + phoneNumber;
        button.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().open(waLink));
        return button;
    }

    private Button createSocialMediaButton(String iconPath, String tooltip, String nombre, String url) {
        Button button = new Button();
        StreamResource iconResource = new StreamResource(nombre, (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream(iconPath));
        Image iconImage = new Image((AbstractStreamResource)iconResource, nombre);
        iconImage.setWidth("24px");
        iconImage.setHeight("24px");
        button.setIcon((Component)iconImage);
        button.getElement().setAttribute("theme", "tertiary");
        button.getElement().setAttribute("title", tooltip);
        button.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().open(url));
        return button;
    }
}

