/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.EstadoscomisionController;
import com.seguros.modelo.Estadoscomision;
import com.seguros.vistas.EstadosComisionView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@PageTitle(value="Datos Maestros -> Estados de Comisi\u00f3n")
@Route(value="estadoscomision", layout=MainLayout.class)
@RolesAllowed(value={"ESTADOSCOMISION", "ADMIN"})
public class EstadosComisionView
extends Div {
    private EstadoscomisionController controller = new EstadoscomisionController();
    private final Grid<Estadoscomision> grid = new Grid(Estadoscomision.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button deleteButton = new Button("Eliminar");

    public EstadosComisionView() {
        this.configureGrid();
        H3 title = new H3("ESTADOS DE COMISI\u00d3N");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione los estados de comisi\u00f3n");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.editButton.setIcon((Component)new Icon(VaadinIcon.PENCIL));
        this.deleteButton.setIcon((Component)new Icon(VaadinIcon.TRASH));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Estadoscomision()));
        this.editButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Estadoscomision selected = (Estadoscomision)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showEditDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a editar");
            }
        });
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> {
            Estadoscomision selected = (Estadoscomision)this.grid.asSingleSelect().getValue();
            if (selected != null) {
                this.showDeleteDialog(selected);
            } else {
                this.showNoSelectionDialog("Por favor, seleccione el registro a eliminar");
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.editButton, this.deleteButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "codigo", "descripcion"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("codigo").setHeader("C\u00d3DIGO");
        this.grid.getColumnByKey("descripcion").setHeader("DESCRIPCI\u00d3N");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
        this.updateList("");
    }

    private void updateList(String value) {
        List estadoscomision = this.getFilteredEstadoscomision(value);
        this.grid.setItems((Collection)estadoscomision);
    }

    private List<Estadoscomision> getFilteredEstadoscomision(String filterValue) {
        List estadoscomision = this.controller.getAllEstadoscomision();
        if (filterValue == null || filterValue.isEmpty()) {
            return estadoscomision;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return estadoscomision.stream().filter(t -> t.getCodigo().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getDescripcion().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Estadoscomision estadoscomision) {
        EditDialog dialog = new EditDialog(this, estadoscomision);
        dialog.open();
    }

    private void showDeleteDialog(Estadoscomision estadoscomision) {
        Dialog dialog = new Dialog();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.add("\u00bfEst\u00e1s seguro de que quieres eliminar este registro?");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button deleteButton = new Button("Eliminar", (ComponentEventListener & Serializable)event -> {
            this.controller.deleteEstadoscomision(estadoscomision.getId().intValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{deleteButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        verticalLayout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{verticalLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

