/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.vistas;

import com.seguros.controlador.CarteraController;
import com.seguros.controlador.DocumentospolizaController;
import com.seguros.modelo.Cartera;
import com.seguros.modelo.Documentospoliza;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.CarteraView;
import com.seguros.vistas.FooterView;
import com.seguros.vistas.MainLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import jakarta.annotation.security.RolesAllowed;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@PageTitle(value="Producci\u00f3n -> Cartera")
@Route(value="cartera", layout=MainLayout.class)
@RolesAllowed(value={"CARTERA", "ADMIN"})
public class CarteraView
extends Div {
    private CarteraController controller = new CarteraController();
    private final Grid<Cartera> grid = new Grid(Cartera.class);
    private final TextField filterText = new TextField();
    private final Button createButton = new Button("Crear");
    private final Button editButton = new Button("Editar");
    private final Button deleteButton = new Button("Eliminar");
    private final Button descargarformatoButton = new Button("Descargar Formato");
    public String textoErroes = "";

    public CarteraView() {
        this.configureGrid();
        H3 title = new H3("CARTERA");
        title.getStyle().set("text-align", "center");
        Paragraph description = new Paragraph("Gestione los estados de cartera de sus clientes con productos financiados");
        description.getStyle().set("text-align", "center");
        this.createButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        this.deleteButton.setIcon((Component)new Icon(VaadinIcon.TRASH));
        this.descargarformatoButton.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD));
        this.createButton.addClickListener((ComponentEventListener & Serializable)e -> this.showEditDialog(new Cartera()));
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> this.showDeleteDialog());
        this.descargarformatoButton.addClickListener((ComponentEventListener & Serializable)e -> {
            ByteArrayResource byteArrayResource;
            DocumentospolizaController controllerdocumentos = new DocumentospolizaController();
            controllerdocumentos.getAllDocumentospoliza("FORMATO_CARTERA");
            ResponseEntity responseEntity = controllerdocumentos.descargarArchivo(((Documentospoliza)InicioApp.getLdocumentospoliza().get(0)).getId().intValue());
            if (responseEntity.getStatusCode() == HttpStatus.OK && (byteArrayResource = (ByteArrayResource)responseEntity.getBody()) != null) {
                byte[] archivo = byteArrayResource.getByteArray();
                String filename = ((Documentospoliza)InicioApp.getLdocumentospoliza().get(0)).getNombrecompletoarchivo();
                StreamResource streamResource = new StreamResource(filename, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(archivo));
                Anchor anchor = new Anchor((AbstractStreamResource)streamResource, "");
                anchor.getElement().setAttribute("download", true);
                UI.getCurrent().add(new Component[]{anchor});
                anchor.getElement().executeJs("this.click()", new Serializable[0]);
            }
        });
        HorizontalLayout barraLoyuot = new HorizontalLayout();
        this.filterText.setPlaceholder("Buscar...");
        this.filterText.setValueChangeMode(ValueChangeMode.EAGER);
        this.filterText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateList((String)event.getValue()));
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{this.createButton, this.deleteButton, this.descargarformatoButton});
        buttonsLayout.setSpacing(true);
        buttonsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout filterLayout = new HorizontalLayout(new Component[]{this.filterText});
        filterLayout.setWidthFull();
        filterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        barraLoyuot.add(new Component[]{buttonsLayout, filterLayout});
        HorizontalLayout footerLayout = new HorizontalLayout();
        FooterView footerView = new FooterView();
        footerLayout.add(new Component[]{footerView});
        Div content = new Div(new Component[]{title, description, new Paragraph(), barraLoyuot, this.grid, footerLayout});
        content.getStyle().set("margin-left", "20px");
        content.getStyle().set("margin-right", "20px");
        content.getStyle().set("padding-top", "2em");
        this.add(new Component[]{content});
    }

    private void configureGrid() {
        this.grid.setColumns(new String[]{"id", "poliza", "credito", "financiadora", "periodo", "estado", "diasMora"});
        this.grid.getColumnByKey("id").setVisible(false);
        this.grid.getColumnByKey("poliza").setHeader("N\u00daMERO DE P\u00d3LIZA");
        this.grid.getColumnByKey("credito").setHeader("N\u00daMERO DE CR\u00c9DITO");
        this.grid.getColumnByKey("financiadora").setHeader("FINANCIERA");
        this.grid.getColumnByKey("periodo").setHeader("PERIODO");
        this.grid.getColumnByKey("estado").setHeader("ESTADO");
        this.grid.getColumnByKey("diasMora").setHeader("D\u00cdAS DE MORA");
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getColumns().forEach(col -> col.setAutoWidth(true));
        this.updateList("");
    }

    private void updateList(String value) {
        List tiposoperacion = this.getFilteredCartera(value);
        this.grid.setItems((Collection)tiposoperacion);
    }

    private List<Cartera> getFilteredCartera(String filterValue) {
        List tiposoperacion = this.controller.getAllCartera();
        if (filterValue == null || filterValue.isEmpty()) {
            return tiposoperacion;
        }
        String filterTextLower = filterValue.toLowerCase(Locale.ENGLISH);
        return tiposoperacion.stream().filter(t -> t.getPeriodo().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getPoliza().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getEstado().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getFinanciadora().toLowerCase(Locale.ENGLISH).contains(filterTextLower) || t.getCredito().toLowerCase(Locale.ENGLISH).contains(filterTextLower)).collect(Collectors.toList());
    }

    private void showEditDialog(Cartera cartera) {
        EditDialog dialog = new EditDialog(this, cartera);
    }

    private void showDeleteDialog() {
        Dialog dialog = new Dialog();
        H3 titulo = new H3("Cargar Cartera");
        this.add(new Component[]{titulo});
        Span notatexto = new Span("Ingrese el periodo y la financiera para la cual desea eliminar la informaci\u00f3n");
        notatexto.getStyle().set("font-weight", "bold");
        notatexto.getStyle().set("font-style", "italic");
        notatexto.getStyle().set("color", "blue");
        FormLayout formLayout = new FormLayout();
        TextField periodoField = new TextField("Periodo:");
        periodoField.setRequired(true);
        formLayout.add(new Component[]{periodoField});
        TextField financieraField = new TextField("Financiera:");
        financieraField.setRequired(true);
        formLayout.add(new Component[]{financieraField});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button loadButton = new Button("Eliminar", (ComponentEventListener & Serializable)event -> {
            this.controller.EliminarCartera(periodoField.getValue(), financieraField.getValue());
            dialog.close();
            this.updateList("");
        });
        Button cancelButton = new Button("Cancelar", (ComponentEventListener & Serializable)event -> dialog.close());
        buttonLayout.add(new Component[]{loadButton, cancelButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1), new FormLayout.ResponsiveStep("300px", 4)});
        formLayout.setColspan((Component)periodoField, 4);
        formLayout.setColspan((Component)financieraField, 4);
        dialog.add(new Component[]{titulo, notatexto, formLayout, buttonLayout});
        dialog.open();
    }

    private void showNoSelectionDialog(String mensaje) {
        Dialog dialog = new Dialog();
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{new Text(mensaje)});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        Button closeButton = new Button("Cerrar", (ComponentEventListener & Serializable)event -> dialog.close());
        closeButton.getStyle().set("margin-left", "auto");
        buttonLayout.add(new Component[]{closeButton});
        layout.add(new Component[]{buttonLayout});
        dialog.add(new Component[]{layout});
        dialog.open();
    }

    public static void showNotification(String message, boolean isError) {
        Notification notification = new Notification();
        if (isError) {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            Icon icon = VaadinIcon.WARNING.create();
            notification.add(new Component[]{icon});
        } else {
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
            Icon icon = VaadinIcon.CHECK_CIRCLE.create();
            notification.add(new Component[]{icon});
        }
        notification.add(message);
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_END);
        notification.getElement().getStyle().set("opacity", "0.6");
        notification.open();
    }
}

