/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.security;

import com.seguros.modelo.Usuarios;
import com.seguros.utilitarios.InicioApp;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Usuarios user = InicioApp.getLusuarios().stream().filter(u -> u.getUsuario().equals(username) && u.getEstado().equalsIgnoreCase("ACTIVO")).findFirst().orElseThrow(() -> new UsernameNotFoundException("User not found with username: " + username));
        List authorities = user.getRoles().stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role.getNombre())).collect(Collectors.toList());
        UserDetails userDetails = User.builder().username(user.getUsuario()).password(user.getPassword()).authorities(authorities).build();
        return userDetails;
    }
}

