/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.seguros.modelo.Estadospoliza;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.EstadosPolizaView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/estadosPoliza"})
public class EstadospolizaController {
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "estadosPoliza";

    @GetMapping(value={"/tiposoperacion"})
    public ModelAndView navigateToEstadosPolizaView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Estadospoliza> getAllEstadospoliza() {
        return InicioApp.getLestadospoliza();
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateEstadospoliza(Estadospoliza estadosPoliza) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(estadosPoliza);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (estadosPoliza.getId() == null) {
                    estadosPoliza.setFechaactualizacion(currentDate.toString());
                    estadosPoliza.setUsuarioactualizacion(userName);
                    estadosPoliza.setFechacreacion(currentDate.toString());
                    estadosPoliza.setUsuariocreacion(userName);
                } else {
                    estadosPoliza.setFechaactualizacion(currentDate.toString());
                    estadosPoliza.setUsuarioactualizacion(userName);
                }
                String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                byte[] authHeaderBytes = authHeader.getBytes();
                String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", encodedAuthHeader);
                HttpEntity requestEntity = new HttpEntity((Object)estadosPoliza, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                InicioApp.cargarEstadospoliza();
                EstadosPolizaView.showNotification((String)"Dato almacenado correctamente", (boolean)false);
                return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
            }
            catch (Exception e) {
                EstadosPolizaView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteEstadospoliza(@PathVariable int id) {
        RestTemplate restTemplate = new RestTemplate();
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.baseUrl + "/" + id, HttpMethod.DELETE, entity, String.class, new Object[0]);
        InicioApp.cargarEstadospoliza();
        EstadosPolizaView.showNotification((String)"Dato eliminado correctamente", (boolean)false);
    }

    private StringBuilder validarDatos(Estadospoliza tipooperacion) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)tipooperacion, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                EstadosPolizaView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }
}

