/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.seguros.modelo.Documentospoliza;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.PolizasView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/Documentospoliza"})
public class DocumentospolizaController {
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "documentospoliza";

    @GetMapping(value={"/documentospoliza"})
    public ModelAndView navigateToDocumentospolizaView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Documentospoliza> getAllDocumentospoliza(String numeroPoliza) {
        RestTemplate restTemplate = new RestTemplate();
        String urlDelServicio = this.baseUrl + "/buscarpoliza/" + numeroPoliza;
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(urlDelServicio, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        List respuesta = (List)responseEntity.getBody();
        InicioApp.setLdocumentospoliza((List)respuesta);
        return InicioApp.getLdocumentospoliza();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Resource> descargarArchivo(@PathVariable int id) {
        Optional<Documentospoliza> documentoOptional = InicioApp.getLdocumentospoliza().stream().filter(docpol -> docpol.getId() == id).findFirst();
        if (documentoOptional.isPresent()) {
            Documentospoliza documento = documentoOptional.get();
            byte[] archivo = documento.getArchivo();
            String nombreArchivo = documento.getNombrecompletoarchivo();
            ByteArrayResource resource = new ByteArrayResource(archivo);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + nombreArchivo + "\""})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
        }
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("error", "El documento no se encontr\u00f3");
        return null;
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateDocumentospoliza(Documentospoliza documentospoliza) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(documentospoliza);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (documentospoliza.getId() == null) {
                    documentospoliza.setFechaactualizacion(currentDate.toString());
                    documentospoliza.setUsuarioactualizacion(userName);
                    documentospoliza.setFechacreacion(currentDate.toString());
                    documentospoliza.setUsuariocreacion(userName);
                } else {
                    documentospoliza.setFechaactualizacion(currentDate.toString());
                    documentospoliza.setUsuarioactualizacion(userName);
                }
                if (documentospoliza.getArchivo() != null) {
                    String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                    byte[] authHeaderBytes = authHeader.getBytes();
                    String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                    HttpHeaders headers = new HttpHeaders();
                    headers.set("Authorization", encodedAuthHeader);
                    HttpEntity requestEntity = new HttpEntity((Object)documentospoliza, (MultiValueMap)headers);
                    ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                    PolizasView.showNotification((String)"Dato archivo cargado correctamente", (boolean)false);
                    return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
                }
                PolizasView.showNotification((String)"Debe seleccionar un archivo", (boolean)true);
            }
            catch (Exception e) {
                PolizasView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        } else {
            return ResponseEntity.badRequest().body((Object)mensaje.toString());
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteDocumentospoliza(@PathVariable int id) {
        RestTemplate restTemplate = new RestTemplate();
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.baseUrl + "/" + id, HttpMethod.DELETE, entity, String.class, new Object[0]);
        PolizasView.showNotification((String)"Dato eliminado correctamente", (boolean)false);
    }

    private StringBuilder validarDatos(Documentospoliza tipooperacion) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)tipooperacion, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                PolizasView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }
}

