/*
 * Decompiled with CFR 0.152.
 */
package com.seguros.controlador;

import com.seguros.modelo.Asesores;
import com.seguros.utilitarios.InicioApp;
import com.seguros.vistas.AsesoresView;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/Asesores"})
public class AsesoresController {
    @Autowired
    private RestTemplate restTemplate;
    private final String baseUrl = InicioApp.getServidorApi() + "asesores";

    @GetMapping(value={"/asesores"})
    public ModelAndView navigateToAsesoresView() {
        return new ModelAndView("forward:/");
    }

    @GetMapping
    @ResponseBody
    public List<Asesores> getAllAsesores() {
        return InicioApp.getLasesores();
    }

    @PostMapping
    public ResponseEntity<?> createOrUpdateAsesores(Asesores asesores) {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder mensaje = this.validarDatos(asesores);
        if (mensaje.isEmpty()) {
            try {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                String userName = "";
                userName = authentication.getName();
                ZoneId zoneId = ZoneId.of("UTC-5");
                LocalDate currentDate = LocalDate.now(zoneId);
                if (asesores.getId() == null) {
                    asesores.setFechaactualizacion(currentDate.toString());
                    asesores.setUsuarioactualizacion(userName);
                    asesores.setFechacreacion(currentDate.toString());
                    asesores.setUsuariocreacion(userName);
                } else {
                    asesores.setFechaactualizacion(currentDate.toString());
                    asesores.setUsuarioactualizacion(userName);
                }
                String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
                byte[] authHeaderBytes = authHeader.getBytes();
                String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", encodedAuthHeader);
                HttpEntity requestEntity = new HttpEntity((Object)asesores, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(this.baseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
                InicioApp.cargarAsesores();
                AsesoresView.showNotification((String)"Dato almacenado correctamente", (boolean)false);
                return ResponseEntity.ok((Object)"Operaci\u00f3n exitosa");
            }
            catch (Exception e) {
                AsesoresView.showNotification((String)"NO ES POSIBLE EJECUTAR LA OPERACION", (boolean)true);
                return ResponseEntity.badRequest().body((Object)mensaje.toString());
            }
        }
        return ResponseEntity.badRequest().body((Object)mensaje.toString());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteAsesores(@PathVariable int id) {
        RestTemplate restTemplate = new RestTemplate();
        String authHeader = InicioApp.getUsuarioApi() + ":" + InicioApp.getPasswordApi();
        byte[] authHeaderBytes = authHeader.getBytes();
        String encodedAuthHeader = "Basic " + Base64.getEncoder().encodeToString(authHeaderBytes);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", encodedAuthHeader);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.baseUrl + "/" + id, HttpMethod.DELETE, entity, String.class, new Object[0]);
        InicioApp.cargarAsesores();
        AsesoresView.showNotification((String)"Dato eliminado correctamente", (boolean)false);
    }

    private StringBuilder validarDatos(Asesores agencia) {
        StringBuilder mensaje = new StringBuilder("");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)agencia, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                mensaje.append("hay errores");
                AsesoresView.showNotification((String)(violation.getPropertyPath().toString() + ": " + violation.getMessage()), (boolean)true);
                System.out.println(violation.getPropertyPath().toString() + " - " + violation.getMessage());
            }
        }
        return mensaje;
    }
}

